/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.services;

import com.ease.gsms.server.model.Dispatch;
import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.model.MessageStatus;
import com.ease.gsms.server.model.util.MD5Hash;
import com.ease.gsms.server.repositories.DeviceRepository;
import com.ease.gsms.server.repositories.DispatchRepository;
import com.ease.gsms.server.services.DispatchService;
import com.ease.gsms.server.services.dispatch.DispatchStatusHolder;
import com.ease.gsms.server.services.dispatch.EmptyDispatchException;
import com.ease.gsms.server.services.dispatch.WorkBalancingService;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DispatchService {
    @Autowired
    DispatchRepository repository;
    @Autowired
    DeviceRepository deviceRepository;
    @Autowired
    WorkBalancingService workBalancingService;

    public UUID dispatch(Dispatch request) throws EmptyDispatchException {
        request.setUUID(UUID.randomUUID());
        request.setMessages(request.getMessages().stream().filter(DispatchService.applicablePredicates((Dispatch)request, (Map)this.getMessagesByHashList(request.getMessages().stream().map(Message::getHash).collect(Collectors.toList()))).stream().reduce(x -> true, Predicate::and)).collect(Collectors.toList()));
        if (request.getMessages().isEmpty()) {
            throw new EmptyDispatchException();
        }
        UUID uuid = this.repository.saveRequest(request);
        this.workBalancingService.addDispatch(request);
        return uuid;
    }

    public Map<MD5Hash, List<Message>> getMessagesByHexHashList(List<String> hashList) {
        return this.getMessagesByHashList(hashList.stream().map(MD5Hash::fromHexString).collect(Collectors.toList()));
    }

    public Long getMessageCountsBetweenCreationTimestamps(Long fromTimestamp, Long toTimestamp, String userName) {
        return this.repository.getMessageCountsBetweenCreationTimestamps(fromTimestamp, toTimestamp, userName);
    }

    public List<Message> getMessagesBetweenCreationTimestamps(Long fromTimestamp, Long toTimestamp, String userName, String sortBy, Boolean descending, Integer startingRow, Integer fetchCount) {
        return this.repository.getMessagesBetweenCreationTimestamps(fromTimestamp, toTimestamp, userName, sortBy, descending, startingRow, fetchCount);
    }

    public Map<MD5Hash, List<Message>> getMessagesByHashList(List<MD5Hash> hashList) {
        return this.repository.getMessagesByHashList(hashList);
    }

    private static Predicate<Message> any(Map<MD5Hash, List<Message>> messagesByHashList, Predicate<Message> predicate) {
        return message -> {
            List preExisting = (List)messagesByHashList.get(message.getHash());
            if (preExisting == null || preExisting.isEmpty()) {
                return true;
            }
            for (Message preExistingMessage : preExisting) {
                if (!predicate.test(preExistingMessage)) continue;
                return true;
            }
            return false;
        };
    }

    private static Predicate<Message> all(Map<MD5Hash, List<Message>> messagesByHashList, Predicate<Message> predicate) {
        return message -> {
            List preExisting = (List)messagesByHashList.get(message.getHash());
            if (preExisting == null || preExisting.isEmpty()) {
                return true;
            }
            for (Message preExistingMessage : preExisting) {
                if (predicate.test(preExistingMessage)) continue;
                return false;
            }
            return true;
        };
    }

    private static List<Predicate<Message>> applicablePredicates(Dispatch request, Map<MD5Hash, List<Message>> messagesByHashList) {
        LinkedList<Predicate<Message>> predicates = new LinkedList<Predicate<Message>>();
        if (!request.getSendToInternationalNumbers().booleanValue()) {
            predicates.add(message -> message.getTo().startsWith("+40"));
        }
        if (!request.getSendToNationalLandlines().booleanValue()) {
            predicates.add(message -> !message.getTo().startsWith("+402") && !message.getTo().startsWith("+403"));
        }
        if (!request.getSendToNationalMobiles().booleanValue()) {
            predicates.add(message -> !message.getTo().startsWith("+407"));
        }
        if (!request.getResendIdenticalSuccessfullyDeliveredMessages().booleanValue()) {
            predicates.add(DispatchService.all(messagesByHashList, (T message) -> message.getStatus() != MessageStatus.DELIVERED));
        }
        if (!request.getResendIdenticalSuccessfullySentMessages().booleanValue()) {
            predicates.add(DispatchService.all(messagesByHashList, (T message) -> {
                switch (1.$SwitchMap$com$ease$gsms$server$model$MessageStatus[message.getStatus().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return false;
                    }
                }
                return true;
            }));
        }
        if (!request.getResendIdenticalUnsuccessfullySentMessages().booleanValue()) {
            predicates.add(DispatchService.all(messagesByHashList, (T message) -> message.getStatus() != MessageStatus.SENDING_FAILED));
        }
        if (!request.getResendUnsentMessages().booleanValue()) {
            predicates.add(DispatchService.any(messagesByHashList, (T message) -> !message.isUnsent()));
        }
        return predicates;
    }

    public DispatchStatusHolder getDispatchStatus(UUID requestId, Principal principal) {
        Dispatch dispatch = this.workBalancingService.getLiveDispatch(requestId, principal.getName());
        if (dispatch != null) {
            return dispatch.getDispatchStatusHolder();
        }
        dispatch = this.repository.getDispatchByUuid(requestId);
        if (dispatch != null && dispatch.getSubmitter().equals(principal.getName())) {
            return new DispatchStatusHolder(dispatch, Collections.emptySet(), false);
        }
        return null;
    }

    public Collection<Dispatch> getLiveDispatches(String userName) {
        return this.workBalancingService.getLiveDispatches(userName);
    }
}

