/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.services;

import com.ease.gsms.server.model.Device;
import com.ease.gsms.server.model.DeviceInfo;
import com.ease.gsms.server.model.Sim;
import com.ease.gsms.server.repositories.DeviceRepository;
import com.ease.gsms.server.services.DeviceUpdateObserver;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class DeviceService {
    @Autowired
    DeviceRepository deviceRepository;
    Map<String, DeviceInfo> onlineDevices = new ConcurrentHashMap();
    Set<DeviceUpdateObserver> observers = new HashSet();

    public boolean addObserver(DeviceUpdateObserver observer) {
        return this.observers.add(observer);
    }

    public boolean removeObserver(DeviceUpdateObserver observer) {
        return this.observers.remove(observer);
    }

    public DeviceInfo[] getUserDevices(String userName) {
        return this.deviceRepository.getUserDevices(userName);
    }

    public Device getDeviceBySimSerialNumber(String simSerialNumber) {
        return this.deviceRepository.getDeviceBySimSerialNumber(simSerialNumber);
    }

    public DeviceInfo getDeviceInfoByUuid(String uuid) {
        return this.deviceRepository.getDeviceInfoByUuid(uuid);
    }

    public void update(Device device, Sim[] sims) {
        this.deviceRepository.update(device, sims);
        if (device.getOnline().booleanValue()) {
            this.onlineDevices.put(device.getUuid(), new DeviceInfo(device, sims));
            this.observers.parallelStream().forEach(observer -> observer.updated(device, sims));
        } else if (this.onlineDevices.remove(device.getUuid()) != null) {
            this.observers.parallelStream().forEach(observer -> observer.updated(device, sims));
        }
    }

    public void offline(String deviceUuid) {
        DeviceInfo deviceInfo = (DeviceInfo)this.onlineDevices.remove(deviceUuid);
        if (deviceInfo == null) {
            deviceInfo = new DeviceInfo(this.deviceRepository.getDeviceByUuid(deviceUuid), this.deviceRepository.getSimsByDeviceUuid(deviceUuid));
        }
        deviceInfo.getDevice().setOnline(Boolean.valueOf(false));
        this.deviceRepository.update(deviceInfo.getDevice(), deviceInfo.getSims());
        DeviceInfo finalDeviceInfo = deviceInfo;
        this.observers.parallelStream().forEach(observer -> observer.updated(finalDeviceInfo.getDevice(), finalDeviceInfo.getSims()));
    }

    @Scheduled(fixedRate=60000L)
    protected void cleanup() {
        for (DeviceInfo deviceInfo : this.deviceRepository.getStaleOnlineDevice(new Date().getTime() - 130000L)) {
            this.offline(deviceInfo.getDevice().getUuid());
        }
    }
}

