/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.repositories.util;

import com.ease.gsms.server.repositories.util.BatchPreparedStatementSetterWithKeyHolder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.InterruptibleBatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class SQLUtil {
    public static final int MAX_IN_CLAUSE_SIZE = 1000;

    public static void setNullableTimestamp(PreparedStatement ps, int parameterIndex, Date timestamp) throws SQLException {
        if (timestamp != null) {
            ps.setLong(parameterIndex, timestamp.getTime());
        } else {
            ps.setNull(parameterIndex, -5);
        }
    }

    public static Date getNullableTimestamp(ResultSet resultSet, String columnLabel) throws SQLException {
        long timestamp = resultSet.getLong(columnLabel);
        if (resultSet.wasNull()) {
            return null;
        }
        return new Date(timestamp);
    }

    public static <T, A> List<T> listQuery(JdbcTemplate template, String baseQuery, RowMapper<T> rowMapper, String placeholder, List<A> list, Object ... args) {
        int i;
        int listSize = list.size();
        if (listSize > 1000) {
            throw new UnsupportedOperationException("listQuery for lists with more than 1000 elements hasn't been implemented yet");
        }
        int argCount = args.length;
        Object[] newArgs = new Object[argCount + listSize];
        int placeHolderIndex = baseQuery.indexOf(placeholder);
        if (placeHolderIndex == -1) {
            throw new IllegalArgumentException(String.format("Placeholder '%s' not found in query: %s", placeholder, baseQuery));
        }
        Pattern p = Pattern.compile("\\?");
        Matcher m = p.matcher(baseQuery.substring(0, placeHolderIndex));
        int questionMarksBeforePlaceholder = 0;
        while (m.find()) {
            ++questionMarksBeforePlaceholder;
        }
        for (i = 0; i < questionMarksBeforePlaceholder; ++i) {
            newArgs[i] = args[i];
        }
        for (A listElement : list) {
            newArgs[i++] = listElement;
        }
        for (i = questionMarksBeforePlaceholder; i < argCount; ++i) {
            newArgs[i + listSize] = args[i];
        }
        return template.query(baseQuery.replace(placeholder, "(" + String.join((CharSequence)",", Collections.nCopies(listSize, "?")) + ")"), newArgs, rowMapper);
    }

    public static <T> void listUpdate(JdbcTemplate template, String baseQuery, String placeholder, List<T> list, Object ... args) {
        int listSize = list.size();
        int argCount = args.length;
        Iterator<T> iterator = list.iterator();
        for (int i = 0; i < listSize; i += 1000) {
            int count = Math.min(1000, listSize - i);
            int max = argCount + count;
            Object[] newArgs = new Object[max];
            System.arraycopy(args, 0, newArgs, 0, argCount);
            for (int j = argCount; j < max; ++j) {
                newArgs[j] = iterator.next();
            }
            template.update(baseQuery.replace(placeholder, "(" + String.join((CharSequence)",", Collections.nCopies(count, "?")) + ")"), newArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generatedKeys(PreparedStatement ps, KeyHolder keyHolder) throws SQLException {
        List keys = keyHolder.getKeyList();
        ResultSet rs = ps.getGeneratedKeys();
        if (rs == null) {
            return;
        }
        try {
            keys.addAll(new RowMapperResultSetExtractor((RowMapper)new ColumnMapRowMapper(), 1).extractData(rs));
        }
        finally {
            rs.close();
        }
    }

    public static <T> int[] batchUpdateWithKeyHolder(JdbcTemplate jdbcTemplate, String sql, BatchPreparedStatementSetterWithKeyHolder<T> pss) {
        return (int[])jdbcTemplate.execute(con -> con.prepareStatement(sql, 1), ps -> {
            try {
                int[] result;
                int batchSize = pss.getBatchSize();
                InterruptibleBatchPreparedStatementSetter ipss = pss instanceof InterruptibleBatchPreparedStatementSetter ? (InterruptibleBatchPreparedStatementSetter)pss : null;
                GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
                try {
                    if (JdbcUtils.supportsBatchUpdates((Connection)ps.getConnection())) {
                        for (int i = 0; i < batchSize; ++i) {
                            pss.setValues(ps, i);
                            if (ipss != null && ipss.isBatchExhausted(i)) break;
                            ps.addBatch();
                        }
                        result = ps.executeBatch();
                        SQLUtil.generatedKeys((PreparedStatement)ps, (KeyHolder)keyHolder);
                    } else {
                        ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                        for (int i = 0; i < batchSize; ++i) {
                            pss.setValues(ps, i);
                            if (ipss != null && ipss.isBatchExhausted(i)) break;
                            rowsAffected.add(ps.executeUpdate());
                            SQLUtil.generatedKeys((PreparedStatement)ps, (KeyHolder)keyHolder);
                        }
                        result = rowsAffected.stream().mapToInt(Integer::intValue).toArray();
                    }
                }
                finally {
                    pss.setPrimaryKey((KeyHolder)keyHolder);
                }
                int[] nArray = result;
                return nArray;
            }
            finally {
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)pss).cleanupParameters();
                }
            }
        });
    }
}

