/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.repositories;

import com.ease.gsms.server.model.Dispatch;
import com.ease.gsms.server.model.DispatchStatus;
import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.model.util.MD5Hash;
import com.ease.gsms.server.repositories.DispatchRepository;
import com.ease.gsms.server.repositories.util.BatchPreparedStatementSetterWithKeyHolder;
import com.ease.gsms.server.repositories.util.SQLUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class DispatchRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${sql.getIdentity}")
    private String callIdentitySQL;
    @Value(value="${sql.sms.getMessagesByHashList}")
    private String getMessagesByHashListSQL;
    @Value(value="${sql.sms.getMessagesByRequestDispatchId}")
    private String getMessagesByRequestDispatchIdSQL;
    @Value(value="${sql.sms.getMessageByIdForUserSQL}")
    private String getMessageByIdForUserSQL;
    @Value(value="${sql.sms.getMessageCountsBetweenCreationTimestampsForUserSQL}")
    private String getMessageCountsBetweenCreationTimestampsForUserSQL;
    @Value(value="${sql.sms.getMessagesBetweenCreationTimestampsForUserSQL}")
    private String getMessagesBetweenCreationTimestampsForUserSQL;
    @Value(value="${sql.sms.getDispatchRequestUUID}")
    private String getDispatchRequestUUIDSQL;
    @Value(value="${sql.sms.getDispatchesByStatus}")
    private String getDispatchesByStatusSQL;
    @Value(value="${sql.sms.getDispatchByUuid}")
    private String getDispatchByUuidSQL;
    @Value(value="${sql.sms.insertDispatchRequest}")
    private String insertDispatchRequestSQL;
    @Value(value="${sql.sms.insertMessage}")
    private String insertMessageSQL;
    @Value(value="${sql.sms.allocateMessages}")
    private String allocateMessagesSQL;
    @Value(value="${sql.sms.updateMessageSentStatus}")
    private String updateMessageSentStatusSQL;
    @Value(value="${sql.sms.updateMessageDeliveryStatus}")
    private String updateMessageDeliveryStatusSQL;
    @Value(value="${sql.sms.updateDispatchStatus}")
    private String updateDispatchStatusSQL;
    private static final Map<String, Field> messageFields = Arrays.stream(Message.class.getDeclaredFields()).collect(Collectors.toMap(Field::getName, Function.identity()));

    public Map<MD5Hash, List<Message>> getMessagesByHashList(List<MD5Hash> hashList) {
        HashMap<MD5Hash, List<Message>> results = new HashMap<MD5Hash, List<Message>>();
        Iterator<MD5Hash> hashIterator = hashList.iterator();
        while (hashIterator.hasNext()) {
            int clauseLimit = 1000;
            StringBuilder sb = new StringBuilder();
            sb.append(this.getMessagesByHashListSQL);
            while (hashIterator.hasNext() && clauseLimit-- > 0) {
                MD5Hash hash = hashIterator.next();
                sb.append(String.format("(hash_high = %d and hash_low = %d)", hash.getHigh(), hash.getLow()));
                if (!hashIterator.hasNext() || clauseLimit <= 0) continue;
                sb.append(" or ");
            }
            this.jdbcTemplate.query(sb.toString(), (RowMapper)new MessageRowMapper()).forEach(message -> results.computeIfAbsent(message.getHash(), md5Hash -> new LinkedList()).add(message));
        }
        return results;
    }

    public UUID saveRequest(Dispatch request) {
        this.jdbcTemplate.update(this.insertDispatchRequestSQL, new Object[]{request.getUUID().toString(), request.getFromICCID(), request.getSubmitter(), request.getSubmissionDate().getTime(), request.getModificationDate().getTime(), request.getSendToInternationalNumbers(), request.getSendToNationalLandlines(), request.getSendToNationalMobiles(), request.getResendIdenticalSuccessfullyDeliveredMessages(), request.getResendIdenticalSuccessfullySentMessages(), request.getResendIdenticalUnsuccessfullySentMessages(), request.getResendUnsentMessages(), request.getAskForDeliveryReport(), request.getPauseBetweenMessagesSeconds(), request.getStatus().getId(), request.getMessageCount()});
        Long dispatchId = (Long)this.jdbcTemplate.queryForObject(this.callIdentitySQL, Long.class);
        request.setId(dispatchId);
        List messages = request.getMessages();
        for (Message message : messages) {
            message.setDispatchRequestId(dispatchId);
        }
        if (!request.getAskForDeliveryReport().booleanValue()) {
            for (Message message : messages) {
                message.setDeliveryStatus(Integer.valueOf(-1));
            }
        }
        SQLUtil.batchUpdateWithKeyHolder((JdbcTemplate)this.jdbcTemplate, (String)this.insertMessageSQL, (BatchPreparedStatementSetterWithKeyHolder)new /* Unavailable Anonymous Inner Class!! */);
        return request.getUUID();
    }

    public void allocateMessages(List<Long> messageIds, String fromICCID, Date allocationDate) {
        SQLUtil.listUpdate((JdbcTemplate)this.jdbcTemplate, (String)this.allocateMessagesSQL, (String)"#ids#", messageIds, (Object[])new Object[]{fromICCID, allocationDate.getTime()});
    }

    public List<Dispatch> getActiveDispatches() {
        List dispatches = SQLUtil.listQuery((JdbcTemplate)this.jdbcTemplate, (String)this.getDispatchesByStatusSQL, (RowMapper)new DispatchRowMapper(), (String)"#status#", Arrays.asList(DispatchStatus.REQUESTED.getId(), DispatchStatus.IN_PROGRESS.getId(), DispatchStatus.PAUSED.getId(), DispatchStatus.SCHEDULED_PAUSE.getId()), (Object[])new Object[0]);
        for (Dispatch dispatch : dispatches) {
            dispatch.setMessages(this.getMessagesByDispatchRequestId(dispatch.getId()));
        }
        return dispatches;
    }

    private Message[] getMessagesByDispatchRequestId(Long dispatchRequestId) {
        return this.jdbcTemplate.query(this.getMessagesByRequestDispatchIdSQL, (RowMapper)new MessageRowMapper(), new Object[]{dispatchRequestId}).toArray(new Message[0]);
    }

    public void updateMessageSentInformation(Long messageId, String fromICCID, Date sendingDate, Integer sendingStatus) {
        this.jdbcTemplate.update(this.updateMessageSentStatusSQL, new Object[]{fromICCID, sendingDate.getTime(), sendingStatus, messageId});
    }

    public void updateMessageDeliveryInformation(Long messageId, Date deliveryDate, Integer deliveryStatus) {
        this.jdbcTemplate.update(this.updateMessageDeliveryStatusSQL, new Object[]{deliveryDate.getTime(), deliveryStatus, messageId});
    }

    public void updateDispatchStatus(Long deliveryId, Date modificationDate, Integer dispatchStatus) {
        this.jdbcTemplate.update(this.updateDispatchStatusSQL, new Object[]{modificationDate.getTime(), dispatchStatus, deliveryId});
    }

    public Dispatch getDispatchByUuid(UUID requestId) {
        try {
            Dispatch dispatch = (Dispatch)this.jdbcTemplate.queryForObject(this.getDispatchByUuidSQL, (RowMapper)new DispatchRowMapper(), new Object[]{requestId.toString()});
            dispatch.setMessages(this.getMessagesByDispatchRequestId(dispatch.getId()));
            return dispatch;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Message getMessageByIdForUser(Long messageId, String user) {
        try {
            return (Message)this.jdbcTemplate.queryForObject(this.getMessageByIdForUserSQL, (RowMapper)new MessageRowMapper(), new Object[]{messageId, user});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Long getMessageCountsBetweenCreationTimestamps(Long fromTimestamp, Long toTimestamp, String userName) {
        return (Long)this.jdbcTemplate.queryForObject(this.getMessageCountsBetweenCreationTimestampsForUserSQL, Long.class, new Object[]{fromTimestamp, toTimestamp, userName});
    }

    public List<Message> getMessagesBetweenCreationTimestamps(Long fromTimestamp, Long toTimestamp, String userName, String sortBy, Boolean descending, Integer startingRow, Integer fetchCount) {
        if (!messageFields.containsKey(sortBy)) {
            throw new IllegalArgumentException("Sorting field must be among message fields, in camel case");
        }
        if ((sortBy = sortBy.replace("Date", "Timestamp")).equalsIgnoreCase("to")) {
            sortBy = "to_number";
        }
        Matcher m = Pattern.compile("(?<=[a-z])[A-Z]").matcher(sortBy);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "_" + m.group().toLowerCase());
        }
        m.appendTail(sb);
        return this.jdbcTemplate.query(this.getMessagesBetweenCreationTimestampsForUserSQL.replace("#sortBy#", sb).replace("#order#", descending != false ? "desc" : "asc").replace("#fetchCount#", fetchCount.toString()).replace("#startingRow#", startingRow.toString()), (RowMapper)new MessageRowMapper(), new Object[]{fromTimestamp, toTimestamp, userName});
    }
}

