/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.repositories;

import com.ease.gsms.server.model.Device;
import com.ease.gsms.server.model.DeviceInfo;
import com.ease.gsms.server.model.Sim;
import com.ease.gsms.server.repositories.DeviceRepository;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class DeviceRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${sql.getIdentity}")
    private String callIdentitySQL;
    @Value(value="${sql.device.getStaleOnlineDevices}")
    private String getStaleOnlineDevicesSQL;
    @Value(value="${sql.device.getStaleOnlineSims}")
    private String getStaleOnlineSimsSQL;
    @Value(value="${sql.device.getDeviceByIdentifier}")
    private String getDeviceByIdentifierSQL;
    @Value(value="${sql.device.getDeviceBySimSerialNumber}")
    private String getDeviceBySimSerialNumberSQL;
    @Value(value="${sql.device.getSimsByDeviceIdentifier}")
    private String getSimsByDeviceIdentifierSQL;
    @Value(value="${sql.device.getSimByIdentifier}")
    private String getSimByIdentifierSQL;
    @Value(value="${sql.device.getUserDevices}")
    private String getUserDevicesSQL;
    @Value(value="${sql.device.getUserSims}")
    private String getUserSimsSQL;
    @Value(value="${sql.device.insertDevice}")
    private String insertDeviceSQL;
    @Value(value="${sql.device.insertSim}")
    private String insertSimSQL;
    @Value(value="${sql.device.updateDevice}")
    private String updateDeviceSQL;
    @Value(value="${sql.device.updateSim}")
    private String updateSimSQL;
    @Value(value="${sql.device.deleteUnreferencedSims}")
    private String deleteUnreferencedSimsSQL;

    public Device getDeviceByUuid(String deviceUuid) {
        try {
            return (Device)this.jdbcTemplate.queryForObject(this.getDeviceByIdentifierSQL, new Object[]{deviceUuid}, (RowMapper)new DeviceRowMapper(this));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Sim[] getSimsByDeviceUuid(String deviceUuid) {
        try {
            return (Sim[])this.jdbcTemplate.query(this.getSimsByDeviceIdentifierSQL, new Object[]{deviceUuid}, (RowMapper)new SimRowMapper(this)).stream().toArray(Sim[]::new);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Sim getSimBySerialNumber(String serialNumber) {
        try {
            return (Sim)this.jdbcTemplate.queryForObject(this.getSimByIdentifierSQL, new Object[]{serialNumber}, (RowMapper)new SimRowMapper(this));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public DeviceInfo getDeviceInfoByUuid(String uuid) {
        Device device = this.getDeviceByUuid(uuid);
        Sim[] sims = this.getSimsByDeviceUuid(uuid);
        if (device != null) {
            return this.createDeviceInfo(Collections.singletonList(device), Arrays.asList(sims))[0];
        }
        return null;
    }

    public Device getDeviceBySimSerialNumber(String simSerialNumber) {
        try {
            return (Device)this.jdbcTemplate.queryForObject(this.getDeviceBySimSerialNumberSQL, new Object[]{simSerialNumber}, (RowMapper)new DeviceRowMapper(this));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Device update(Device device) {
        Device existing;
        String deviceUuid = device.getUuid();
        Device device2 = existing = deviceUuid == null ? null : this.getDeviceByUuid(deviceUuid);
        if (existing != null) {
            device.setId(existing.getId());
            this.jdbcTemplate.update(this.updateDeviceSQL, (PreparedStatementSetter)new DevicePreparedStatementSetter(this, device));
        } else {
            this.jdbcTemplate.update(this.insertDeviceSQL, (PreparedStatementSetter)new DevicePreparedStatementSetter(this, device));
            device.setId((Long)this.jdbcTemplate.queryForObject(this.callIdentitySQL, Long.class));
        }
        return device;
    }

    public void update(Sim sim) {
        Sim existing;
        String simSerialNumber = sim.getSimSerialNumber();
        Sim sim2 = existing = simSerialNumber == null ? null : this.getSimBySerialNumber(simSerialNumber);
        if (existing != null) {
            sim.setId(existing.getId());
            this.jdbcTemplate.update(this.updateSimSQL, (PreparedStatementSetter)new SimPreparedStatementSetter(this, sim));
        } else {
            this.jdbcTemplate.update(this.insertSimSQL, (PreparedStatementSetter)new SimPreparedStatementSetter(this, sim));
            sim.setId((Long)this.jdbcTemplate.queryForObject(this.callIdentitySQL, Long.class));
        }
    }

    public void update(Device device, Sim[] sims) {
        this.update(device);
        for (Sim sim : sims) {
            sim.setPhysicalDeviceId(device.getId());
            this.update(sim);
        }
        List validSimSerialNumbers = Arrays.stream(sims).map(Sim::getSimSerialNumber).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        sb.append(this.deleteUnreferencedSimsSQL);
        int validSimCount = validSimSerialNumbers.size();
        if (validSimCount > 0) {
            sb.append(" and sim_serial_number not in (").append(String.join((CharSequence)",", Collections.nCopies(validSimCount, "?"))).append(")");
        }
        Object[] args = new Object[validSimCount + 1];
        args[0] = device.getId();
        System.arraycopy(validSimSerialNumbers.toArray(), 0, args, 1, validSimCount);
        this.jdbcTemplate.update(sb.toString(), args);
    }

    public DeviceInfo[] getStaleOnlineDevice(long timestamp) {
        return this.createDeviceInfo(this.jdbcTemplate.query(this.getStaleOnlineDevicesSQL, new Object[]{timestamp}, (RowMapper)new DeviceRowMapper(this)), this.jdbcTemplate.query(this.getStaleOnlineSimsSQL, new Object[]{timestamp}, (RowMapper)new SimRowMapper(this)));
    }

    public DeviceInfo[] getUserDevices(String userName) {
        return this.createDeviceInfo(this.jdbcTemplate.query(this.getUserDevicesSQL, new Object[]{userName}, (RowMapper)new DeviceRowMapper(this)), this.jdbcTemplate.query(this.getUserSimsSQL, new Object[]{userName}, (RowMapper)new SimRowMapper(this)));
    }

    private DeviceInfo[] createDeviceInfo(List<Device> deviceList, List<Sim> simList) {
        DeviceInfo[] deviceInfos = new DeviceInfo[deviceList.size()];
        int i = 0;
        for (Device device : deviceList) {
            deviceInfos[i++] = new DeviceInfo(device, (Sim[])simList.stream().filter(sim -> sim.getPhysicalDeviceId().equals(device.getId())).toArray(Sim[]::new));
        }
        return deviceInfos;
    }
}

