/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.repositories;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class ApiKeyRepository {
    @Value(value="${sql.users.getUsernameByApiKey}")
    private String getUsernameByApiKeySQL;
    @Value(value="${sql.users.getApiKeysForUsername}")
    private String getApiKeysForUsernameSQL;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public String getUsernameByApiKey(UUID apiKey) {
        try {
            return (String)this.jdbcTemplate.queryForObject(this.getUsernameByApiKeySQL, String.class, new Object[]{apiKey});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public List<UUID> getApiKeysForUsername(String userName) {
        return this.jdbcTemplate.queryForList(this.getApiKeysForUsernameSQL, String.class, new Object[]{userName}).stream().map(UUID::fromString).collect(Collectors.toList());
    }
}

