/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.model.util;

import com.ease.gsms.server.model.util.IDEnum;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;

public class IDEnumDeserializer
extends JsonDeserializer<IDEnum>
implements ContextualDeserializer {
    JavaType type;

    public IDEnumDeserializer() {
    }

    public IDEnumDeserializer(JavaType type) {
        this.type = type;
    }

    public IDEnum deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Class cl = this.type.getRawClass();
        Class id = this.type.getRawClass();
        if (jsonParser.getCurrentToken().isStructStart()) {
            String fieldName = jsonParser.nextFieldName();
            jsonParser.nextToken();
            jsonParser.nextToken();
            return (IDEnum)Enum.valueOf(cl, fieldName);
        }
        if (jsonParser.getCurrentToken().isNumeric()) {
            try {
                return IDEnum.byId((Class)id, (int)jsonParser.getValueAsInt());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return (IDEnum)Enum.valueOf(cl, jsonParser.getValueAsString());
    }

    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JavaType contextualType = deserializationContext.getContextualType();
        return new IDEnumDeserializer(contextualType);
    }
}

