/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.model.util;

import com.ease.gsms.server.model.util.ValidE164Number;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class E164NumberValidator
implements ConstraintValidator<ValidE164Number, String> {
    private final ThreadLocal<Pattern> pattern = ThreadLocal.withInitial(() -> Pattern.compile("^\\+[0-9]{10,14}$"));

    public void initialize(ValidE164Number constraintAnnotation) {
    }

    public boolean isValid(String phoneNumberString, ConstraintValidatorContext constraintValidatorContext) {
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        try {
            return phoneNumberString == null || ((Pattern)this.pattern.get()).matcher(phoneNumberString).matches() && phoneNumberUtil.isPossibleNumber(phoneNumberUtil.parse((CharSequence)phoneNumberString, "RO"));
        }
        catch (NumberParseException e) {
            return false;
        }
    }
}

