/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.model;

import com.ease.gsms.server.model.MessageStatus;
import com.ease.gsms.server.model.util.MD5Hash;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class Message {
    private Long id;
    private MD5Hash hash;
    private String fromICCID;
    private String to;
    private String content;
    private Date creationDate;
    private volatile Date allocationDate;
    private volatile Date sentDate;
    private volatile Date deliveredDate;
    private volatile Integer sendingStatus;
    private volatile Integer deliveryStatus;
    private Long dispatchRequestId;

    public Message(Long id, String fromICCID, String to, String content, Date creationDate, Date allocationDate, Date sentDate, Date deliveredDate, Integer sendingStatus, Integer deliveryStatus, Long dispatchRequestId) {
        this.id = id;
        this.fromICCID = fromICCID;
        this.to = to;
        this.content = content;
        this.creationDate = creationDate;
        this.allocationDate = allocationDate;
        this.sentDate = sentDate;
        this.deliveredDate = deliveredDate;
        this.dispatchRequestId = dispatchRequestId;
        this.sendingStatus = sendingStatus;
        this.deliveryStatus = deliveryStatus;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(to.getBytes());
            digest.update(content.getBytes());
            this.hash = MD5Hash.fromBytes((byte[])digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public Message(String to, String content, Long dispatchRequestId) {
        this(null, null, to, content, new Date(), null, null, null, Integer.valueOf(0), Integer.valueOf(0), dispatchRequestId);
    }

    public Message(String to, String content) {
        this(null, null, to, content, new Date(), null, null, null, Integer.valueOf(0), Integer.valueOf(0), null);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MD5Hash getHash() {
        return this.hash;
    }

    public String getFromICCID() {
        return this.fromICCID;
    }

    public void setFromICCID(String fromICCID) {
        this.fromICCID = fromICCID;
    }

    public String getTo() {
        return this.to;
    }

    public String getContent() {
        return this.content;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getAllocationDate() {
        return this.allocationDate;
    }

    public void setAllocationDate(Date allocationDate) {
        this.allocationDate = allocationDate;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public Date getDeliveredDate() {
        return this.deliveredDate;
    }

    public void setDeliveredDate(Date deliveredDate) {
        this.deliveredDate = deliveredDate;
    }

    public Integer getSendingStatus() {
        return this.sendingStatus;
    }

    public void setSendingStatus(Integer sendingStatus) {
        this.sendingStatus = sendingStatus;
    }

    public Integer getDeliveryStatus() {
        return this.deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public Long getDispatchRequestId() {
        return this.dispatchRequestId;
    }

    public void setDispatchRequestId(Long dispatchRequestId) {
        this.dispatchRequestId = dispatchRequestId;
    }

    public MessageStatus getStatus() {
        if (this.deliveredDate != null) {
            if (this.deliveryStatus == 1) {
                return MessageStatus.DELIVERED;
            }
            return MessageStatus.DELIVERY_FAILED;
        }
        if (this.sentDate != null) {
            if (this.sendingStatus == 1) {
                return MessageStatus.SENT;
            }
            return MessageStatus.SENDING_FAILED;
        }
        if (this.allocationDate != null) {
            return MessageStatus.ALLOCATED;
        }
        return MessageStatus.CREATED;
    }

    public boolean isUnsent() {
        return this.getStatus().equals((Object)MessageStatus.CREATED) || this.getStatus().equals((Object)MessageStatus.ALLOCATED) || this.getStatus().equals((Object)MessageStatus.RESERVED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.id, message.id) && Objects.equals(this.hash, message.hash) && Objects.equals(this.fromICCID, message.fromICCID) && Objects.equals(this.to, message.to) && Objects.equals(this.content, message.content) && Objects.equals(this.creationDate, message.creationDate) && Objects.equals(this.allocationDate, message.allocationDate) && Objects.equals(this.sentDate, message.sentDate) && Objects.equals(this.deliveredDate, message.deliveredDate) && Objects.equals(this.sendingStatus, message.sendingStatus) && Objects.equals(this.deliveryStatus, message.deliveryStatus) && Objects.equals(this.dispatchRequestId, message.dispatchRequestId);
    }
}

