/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.model;

import com.ease.gsms.server.model.DispatchStatus;
import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.services.dispatch.DispatchStatusHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Dispatch {
    Long id;
    UUID uuid;
    String fromICCID;
    String submitter;
    Date submissionDate;
    Date modificationDate;
    Boolean sendToInternationalNumbers;
    Boolean sendToNationalLandlines;
    Boolean sendToNationalMobiles;
    Boolean resendIdenticalSuccessfullyDeliveredMessages;
    Boolean resendIdenticalSuccessfullySentMessages;
    Boolean resendIdenticalUnsuccessfullySentMessages;
    Boolean resendUnsentMessages;
    Boolean askForDeliveryReport;
    Integer pauseBetweenMessagesSeconds;
    volatile DispatchStatus status;
    List<Message> messages;
    int messageCount;
    Map<Long, Message> messagesById = null;
    transient DispatchStatusHolder dispatchStatusHolder;

    public Dispatch(Long id, UUID uuid, String fromICCID, String submitter, Date submissionDate, Date modificationDate, Boolean sendToInternationalNumbers, Boolean sendToNationalLandlines, Boolean sendToNationalMobiles, Boolean resendIdenticalSuccessfullyDeliveredMessages, Boolean resendIdenticalSuccessfullySentMessages, Boolean resendIdenticalUnsuccessfullySentMessages, Boolean resendUnsentMessages, Boolean askForDeliveryReport, Integer pauseBetweenMessagesSeconds, DispatchStatus status, Message[] messages) {
        this.id = id;
        this.uuid = uuid;
        this.fromICCID = fromICCID;
        this.submitter = submitter;
        this.submissionDate = submissionDate;
        this.modificationDate = modificationDate;
        this.sendToInternationalNumbers = sendToInternationalNumbers;
        this.sendToNationalLandlines = sendToNationalLandlines;
        this.sendToNationalMobiles = sendToNationalMobiles;
        this.resendIdenticalSuccessfullyDeliveredMessages = resendIdenticalSuccessfullyDeliveredMessages;
        this.resendIdenticalSuccessfullySentMessages = resendIdenticalSuccessfullySentMessages;
        this.resendIdenticalUnsuccessfullySentMessages = resendIdenticalUnsuccessfullySentMessages;
        this.resendUnsentMessages = resendUnsentMessages;
        this.askForDeliveryReport = askForDeliveryReport;
        this.pauseBetweenMessagesSeconds = pauseBetweenMessagesSeconds;
        this.status = status;
        this.setMessages(messages);
    }

    public Dispatch(Long id, UUID uuid, String fromICCID, String submitter, Date submissionDate, Date modificationDate, Boolean sendToInternationalNumbers, Boolean sendToNationalLandlines, Boolean sendToNationalMobiles, Boolean resendIdenticalSuccessfullyDeliveredMessages, Boolean resendIdenticalSuccessfullySentMessages, Boolean resendIdenticalUnsuccessfullySentMessages, Boolean resendUnsentMessages, Boolean askForDeliveryReport, Integer pauseBetweenMessagesSeconds, DispatchStatus status, int messageCount) {
        this.id = id;
        this.uuid = uuid;
        this.fromICCID = fromICCID;
        this.submitter = submitter;
        this.submissionDate = submissionDate;
        this.modificationDate = modificationDate;
        this.sendToInternationalNumbers = sendToInternationalNumbers;
        this.sendToNationalLandlines = sendToNationalLandlines;
        this.sendToNationalMobiles = sendToNationalMobiles;
        this.resendIdenticalSuccessfullyDeliveredMessages = resendIdenticalSuccessfullyDeliveredMessages;
        this.resendIdenticalSuccessfullySentMessages = resendIdenticalSuccessfullySentMessages;
        this.resendIdenticalUnsuccessfullySentMessages = resendIdenticalUnsuccessfullySentMessages;
        this.resendUnsentMessages = resendUnsentMessages;
        this.askForDeliveryReport = askForDeliveryReport;
        this.pauseBetweenMessagesSeconds = pauseBetweenMessagesSeconds;
        this.status = status;
        this.messageCount = messageCount;
    }

    public Dispatch(String fromICCID, String submitter, Boolean sendToInternationalNumbers, Boolean sendToNationalLandlines, Boolean sendToNationalMobiles, Boolean resendIdenticalSuccessfullyDeliveredMessages, Boolean resendIdenticalSuccessfullySentMessages, Boolean resendIdenticalUnsuccessfullySentMessages, Boolean resendUnsentMessages, Boolean askForDeliveryReport, Integer pauseBetweenMessagesSeconds, Message[] messages) {
        this(null, null, fromICCID, submitter, new Date(), new Date(), sendToInternationalNumbers, sendToNationalLandlines, sendToNationalMobiles, resendIdenticalSuccessfullyDeliveredMessages, resendIdenticalSuccessfullySentMessages, resendIdenticalUnsuccessfullySentMessages, resendUnsentMessages, askForDeliveryReport, pauseBetweenMessagesSeconds, DispatchStatus.REQUESTED, messages);
    }

    public Long getId() {
        return this.id;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getFromICCID() {
        return this.fromICCID;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public Date getSubmissionDate() {
        return this.submissionDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public Boolean getSendToInternationalNumbers() {
        return this.sendToInternationalNumbers;
    }

    public Boolean getSendToNationalLandlines() {
        return this.sendToNationalLandlines;
    }

    public Boolean getSendToNationalMobiles() {
        return this.sendToNationalMobiles;
    }

    public Boolean getResendIdenticalSuccessfullyDeliveredMessages() {
        return this.resendIdenticalSuccessfullyDeliveredMessages;
    }

    public Boolean getResendIdenticalSuccessfullySentMessages() {
        return this.resendIdenticalSuccessfullySentMessages;
    }

    public Boolean getResendIdenticalUnsuccessfullySentMessages() {
        return this.resendIdenticalUnsuccessfullySentMessages;
    }

    public Boolean getResendUnsentMessages() {
        return this.resendUnsentMessages;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Boolean getAskForDeliveryReport() {
        return this.askForDeliveryReport;
    }

    public Integer getPauseBetweenMessagesSeconds() {
        return this.pauseBetweenMessagesSeconds;
    }

    public DispatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(DispatchStatus status) {
        this.status = status;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public int getUnsentMessageCount() {
        return (int)this.unsent().count();
    }

    public static boolean isUnsent(Message m) {
        return m.isUnsent();
    }

    public Stream<Message> unsent() {
        return this.messages.stream().filter(Dispatch::isUnsent);
    }

    public void setMessages(Message[] messages) {
        this.setMessages(messages != null ? Arrays.asList(messages) : new LinkedList());
    }

    public void setMessages(List<Message> messages) {
        this.messages = Collections.synchronizedList(messages);
        this.messageCount = this.messages.size();
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public synchronized Map<Long, Message> getMessagesById() {
        if (this.messagesById != null) {
            return this.messagesById;
        }
        this.messagesById = this.messages.stream().collect(Collectors.toMap(Message::getId, Function.identity()));
        return this.messagesById;
    }

    public DispatchStatusHolder getDispatchStatusHolder() {
        return this.dispatchStatusHolder;
    }

    public void setDispatchStatusHolder(DispatchStatusHolder dispatchStatusHolder) {
        this.dispatchStatusHolder = dispatchStatusHolder;
    }
}

