/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.controllers.filters;

import com.ease.gsms.server.controllers.filters.ApiKeyAuthenticationToken;
import com.ease.gsms.server.repositories.ApiKeyRepository;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class ApiKeyAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private Logger logger = LoggerFactory.getLogger(ApiKeyAuthenticationFilter.class);
    private ApiKeyRepository apiKeyRepository;
    private AuthenticationManager authenticationManager;
    private UserDetailsService userDetailsService;

    public ApiKeyAuthenticationFilter(AuthenticationManager authenticationManager, ApiKeyRepository apiKeyRepository, UserDetailsService userDetailsService) {
        super((RequestMatcher)new RequestHeaderRequestMatcher("X-Api-Key"));
        this.authenticationManager = authenticationManager;
        this.setAuthenticationManager(this.authenticationManager);
        this.apiKeyRepository = apiKeyRepository;
        this.userDetailsService = userDetailsService;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        UUID apiKey;
        String apiKeyHeader = request.getHeader("X-Api-Key");
        try {
            apiKey = UUID.fromString(apiKeyHeader);
        }
        catch (Exception e) {
            throw new BadCredentialsException("Wrong api key format");
        }
        String userName = this.apiKeyRepository.getUsernameByApiKey(apiKey);
        if (userName == null) {
            throw new BadCredentialsException(String.format("Unknown api key: %s", apiKey));
        }
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(userName);
        Collection authorities = userDetails.getAuthorities();
        return this.getAuthenticationManager().authenticate((Authentication)new ApiKeyAuthenticationToken((Object)userDetails, (Object)apiKey, authorities));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(authResult);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

