/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.controllers.api.v1.errors;

import com.ease.gsms.server.controllers.api.v1.errors.ApiError;
import com.ease.gsms.server.controllers.api.v1.errors.ApiValidationError;
import javax.validation.ConstraintViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ErrorTranslator {
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public ResponseEntity<ApiError> handleMissingServletRequestParameter(MissingServletRequestParameterException ex) {
        return new ResponseEntity((Object)new ApiError(HttpStatus.BAD_REQUEST, String.format("%s parameter is missing", ex.getParameterName()), (Throwable)ex), HttpStatus.BAD_REQUEST);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseEntity<ApiError> handleMethodArgumentNotValid(MethodArgumentNotValidException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage("Validation error");
        ex.getBindingResult().getFieldErrors().forEach(fieldError -> apiError.addSubError(new ApiValidationError(fieldError)));
        ex.getBindingResult().getGlobalErrors().forEach(objectError -> apiError.addSubError(new ApiValidationError(objectError)));
        return new ResponseEntity((Object)apiError, apiError.getStatus());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<ApiError> handleConstraintViolation(ConstraintViolationException ex) {
        ApiError apiError = new ApiError(HttpStatus.BAD_REQUEST);
        apiError.setMessage("Validation error");
        ex.getConstraintViolations().forEach(constraintViolation -> apiError.addSubError(new ApiValidationError(constraintViolation)));
        return new ResponseEntity((Object)apiError, apiError.getStatus());
    }
}

