/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.controllers.api.v1.errors;

import com.ease.gsms.server.controllers.api.v1.errors.ApiSubError;
import java.util.Objects;
import javax.validation.ConstraintViolation;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ApiValidationError
extends ApiSubError {
    private String object;
    private String field;
    private Object rejectedValue;
    private String message;

    public ApiValidationError() {
    }

    public ApiValidationError(String object, String message) {
        this.object = object;
        this.message = message;
    }

    public ApiValidationError(String object, String field, Object rejectedValue, String message) {
        this.object = object;
        this.field = field;
        this.rejectedValue = rejectedValue;
        this.message = message;
    }

    public ApiValidationError(FieldError fieldError) {
        this(fieldError.getObjectName(), fieldError.getField(), fieldError.getRejectedValue(), fieldError.getDefaultMessage());
    }

    public ApiValidationError(ObjectError objectError) {
        this(objectError.getObjectName(), objectError.getDefaultMessage());
    }

    public ApiValidationError(ConstraintViolation<?> constraintViolation) {
        this(constraintViolation.getRootBeanClass().getSimpleName(), ((PathImpl)constraintViolation.getPropertyPath()).getLeafNode().asString(), constraintViolation.getInvalidValue(), constraintViolation.getMessage());
    }

    public String getObject() {
        return this.object;
    }

    public String getField() {
        return this.field;
    }

    public Object getRejectedValue() {
        return this.rejectedValue;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiValidationError that = (ApiValidationError)o;
        return Objects.equals(this.object, that.object) && Objects.equals(this.field, that.field) && Objects.equals(this.rejectedValue, that.rejectedValue) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.field, this.rejectedValue, this.message);
    }
}

