/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.controllers.api.v1.errors;

import com.ease.gsms.server.controllers.api.v1.errors.ApiSubError;
import com.ease.gsms.server.controllers.api.v1.errors.ApiValidationError;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.http.HttpStatus;

public class ApiError {
    private HttpStatus status;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy hh:mm:ss")
    private LocalDateTime timestamp;
    private String message;
    private String debugMessage;
    private Set<ApiSubError> subErrors = new LinkedHashSet();

    public ApiError() {
        this.timestamp = LocalDateTime.now();
    }

    public ApiError(HttpStatus status) {
        this();
        this.status = status;
    }

    ApiError(HttpStatus status, Throwable ex) {
        this();
        this.status = status;
        this.message = "Unexpected error";
        this.debugMessage = ex.getLocalizedMessage();
    }

    public ApiError(HttpStatus status, String message, Throwable ex) {
        this();
        this.status = status;
        this.message = message;
        this.debugMessage = ex.getLocalizedMessage();
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    void setStatus(HttpStatus status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDebugMessage() {
        return this.debugMessage;
    }

    void setDebugMessage(String debugMessage) {
        this.debugMessage = debugMessage;
    }

    public void addSubError(ApiValidationError apiValidationError) {
        this.subErrors.add(apiValidationError);
    }

    public Set<ApiSubError> getSubErrors() {
        return Collections.unmodifiableSet(this.subErrors);
    }
}

