/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.controllers.api.v1;

import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.model.util.ValidE164Number;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class SMSMessage {
    @Schema(description="What number should the message be sent to", example="+40721111111", required=true)
    @ValidE164Number
    @NotNull
    String to;
    @Schema(description="The textual message to send", required=true)
    @Size(min=1, max=612)
    @NotNull
    @Size(min=1, max=612) @NotNull String content;

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Message toMessage() {
        return new Message(this.to, this.content);
    }
}

