/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.controllers.api.v1;

import com.ease.gsms.server.controllers.api.v1.SMSMessage;
import com.ease.gsms.server.model.util.ValidICCID;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

public class SMSDispatchRequest {
    @Schema(description="From which SIM should the message be sent, identified by ICCID", example="18-22 digit number identifying the SIM card, starts with 89", required=false)
    @ValidICCID
    String fromICCID;
    @Schema(description="Should messages be sent to international numbers ?", example="false", required=false)
    Boolean sendToInternationalNumbers = false;
    @Schema(description="Should messages be sent to national landlines ?", example="false", required=false)
    Boolean sendToNationalLandlines = false;
    @Schema(description="Should messages be sent to national mobiles ?", example="true", required=false)
    Boolean sendToNationalMobiles = true;
    @Schema(description="Should messages with identical content be re-sent to the same number, if they were previously delivered successfully ?", example="false", required=false)
    Boolean resendIdenticalSuccessfullyDeliveredMessages = false;
    @Schema(description="Should messages with identical content be re-sent to the same number, if they were previously sent successfully (but not delivered) ?", example="false", required=false)
    Boolean resendIdenticalSuccessfullySentMessages = false;
    @Schema(description="Should messages with identical content be re-sent to the same number, if they were not previously sent successfully ?", example="true", required=false)
    Boolean resendIdenticalUnsuccessfullySentMessages = true;
    @Schema(description="Should messages with identical content be re-sent to the same number, if they are already in the pipeline of another request ?", example="false", required=false)
    Boolean resendIdenticalUnsent = false;
    @Schema(description="Should a delivery report be asked from the network ?", example="false", required=false)
    Boolean askForDeliveryReport = false;
    @Schema(description="How many seconds should we pause for between one message being reported as sent and sending the next one in a dispatch?", example="0", required=false)
    Integer pauseBetweenMessagesSeconds = 0;
    @NotEmpty
    @Valid
    @Schema(description="Messages that should be sent", required=true)
    SMSMessage[] messages;

    public String getFromICCID() {
        return this.fromICCID;
    }

    public void setFromICCID(String fromICCID) {
        this.fromICCID = fromICCID;
    }

    public SMSMessage[] getMessages() {
        return this.messages;
    }

    public void setMessages(SMSMessage[] messages) {
        this.messages = messages;
    }

    public Boolean getSendToInternationalNumbers() {
        return this.sendToInternationalNumbers;
    }

    public void setSendToInternationalNumbers(Boolean sendToInternationalNumbers) {
        this.sendToInternationalNumbers = sendToInternationalNumbers;
    }

    public Boolean getSendToNationalLandlines() {
        return this.sendToNationalLandlines;
    }

    public void setSendToNationalLandlines(Boolean sendToNationalLandlines) {
        this.sendToNationalLandlines = sendToNationalLandlines;
    }

    public Boolean getSendToNationalMobiles() {
        return this.sendToNationalMobiles;
    }

    public void setSendToNationalMobiles(Boolean sendToNationalMobiles) {
        this.sendToNationalMobiles = sendToNationalMobiles;
    }

    public Boolean getResendIdenticalSuccessfullyDeliveredMessages() {
        return this.resendIdenticalSuccessfullyDeliveredMessages;
    }

    public void setResendIdenticalSuccessfullyDeliveredMessages(Boolean resendIdenticalSuccessfullyDeliveredMessages) {
        this.resendIdenticalSuccessfullyDeliveredMessages = resendIdenticalSuccessfullyDeliveredMessages;
    }

    public Boolean getResendIdenticalSuccessfullySentMessages() {
        return this.resendIdenticalSuccessfullySentMessages;
    }

    public void setResendIdenticalSuccessfullySentMessages(Boolean resendIdenticalSuccessfullySentMessages) {
        this.resendIdenticalSuccessfullySentMessages = resendIdenticalSuccessfullySentMessages;
    }

    public Boolean getResendIdenticalUnsuccessfullySentMessages() {
        return this.resendIdenticalUnsuccessfullySentMessages;
    }

    public void setResendIdenticalUnsuccessfullySentMessages(Boolean resendIdenticalUnsuccessfullySentMessages) {
        this.resendIdenticalUnsuccessfullySentMessages = resendIdenticalUnsuccessfullySentMessages;
    }

    public Boolean getResendIdenticalUnsent() {
        return this.resendIdenticalUnsent;
    }

    public void setResendIdenticalUnsent(Boolean resendIdenticalUnsent) {
        this.resendIdenticalUnsent = resendIdenticalUnsent;
    }

    public Boolean getAskForDeliveryReport() {
        return this.askForDeliveryReport;
    }

    public void setAskForDeliveryReport(Boolean askForDeliveryReport) {
        this.askForDeliveryReport = askForDeliveryReport;
    }

    public Integer getPauseBetweenMessagesSeconds() {
        return this.pauseBetweenMessagesSeconds;
    }

    public void setPauseBetweenMessagesSeconds(Integer pauseBetweenMessagesSeconds) {
        this.pauseBetweenMessagesSeconds = pauseBetweenMessagesSeconds;
    }
}

