/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.controllers.api.v1;

import com.ease.gsms.server.controllers.api.v1.MessageDeliveryInfo;
import com.ease.gsms.server.controllers.api.v1.MessageSendingInfo;
import com.ease.gsms.server.controllers.api.v1.SMSController;
import com.ease.gsms.server.controllers.api.v1.SMSDispatchRequest;
import com.ease.gsms.server.controllers.api.v1.SMSMessage;
import com.ease.gsms.server.model.Device;
import com.ease.gsms.server.model.Dispatch;
import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.model.util.MD5Hash;
import com.ease.gsms.server.services.DeviceService;
import com.ease.gsms.server.services.DispatchService;
import com.ease.gsms.server.services.dispatch.DispatchStatusHolder;
import com.ease.gsms.server.services.dispatch.EmptyDispatchException;
import com.ease.gsms.server.services.dispatch.MessageSender;
import com.ease.gsms.server.services.dispatch.WorkBalancingService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;

@RestController
@RequestMapping(value={"/api/v1/sms"}, produces={"application/json"})
@Validated
public class SMSController {
    @Autowired
    private DispatchService dispatchService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private WorkBalancingService workService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    private final Map<String, Map<String, MessageSender>> workersBySessionId = new ConcurrentHashMap();

    @PostConstruct
    private void init() {
        this.workService.addDispatchUpdateObserver((userName, dispatchStatusHolder) -> this.simpMessagingTemplate.convertAndSendToUser(userName, String.format("/topic/dispatch/%s/status-updates", dispatchStatusHolder.getUUID()), (Object)dispatchStatusHolder));
    }

    @RequestMapping(value={"/send"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('SUBMITTER')")
    @Operation(summary="Processes an SMSDispatchRequest", description="Requires being an authenticated user with the SUBMITTER role", security={@SecurityRequirement(name="api-key")})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="SMSDispatchRequest successfully received"), @ApiResponse(responseCode="400", description="The SMSDispatchRequest is invalid"), @ApiResponse(responseCode="500", description="Something went wrong during processing")})
    public ResponseEntity<UUID> sendSMS(@Valid @RequestBody SMSDispatchRequest request, Authentication authentication) throws EmptyDispatchException {
        SMSMessage[] smsMessages = request.getMessages();
        int messageCount = smsMessages.length;
        Message[] messages = new Message[messageCount];
        for (int i = 0; i < messageCount; ++i) {
            messages[i] = smsMessages[i].toMessage();
        }
        Dispatch dispatch = new Dispatch(request.getFromICCID(), authentication.getName(), request.getSendToInternationalNumbers(), request.getSendToNationalLandlines(), request.getSendToNationalMobiles(), request.getResendIdenticalSuccessfullyDeliveredMessages(), request.getResendIdenticalSuccessfullySentMessages(), request.getResendIdenticalUnsuccessfullySentMessages(), request.getResendIdenticalUnsent(), request.getAskForDeliveryReport(), request.getPauseBetweenMessagesSeconds(), messages);
        UUID uuid = this.dispatchService.dispatch(dispatch);
        this.simpMessagingTemplate.convertAndSendToUser(authentication.getName(), "/topic/dispatch/new", (Object)dispatch.getUUID());
        return ResponseEntity.created((URI)URI.create(String.format("/request/%s", uuid))).body((Object)uuid);
    }

    @RequestMapping(value={"/active-dispatches"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('SUBMITTER')")
    @Operation(summary="Lists the ids of all active dispatches", description="Requires being an authenticated user with the SUBMITTER role", security={@SecurityRequirement(name="api-key")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of UUID")})
    public ResponseEntity<Collection<UUID>> getActiveDispatches(Authentication authentication) {
        return ResponseEntity.ok(this.dispatchService.getLiveDispatches(authentication.getName()).stream().sorted((d1, d2) -> new CompareToBuilder().append((Object)d1.getSubmissionDate(), (Object)d2.getSubmissionDate()).toComparison()).map(Dispatch::getUUID).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/status/{requestId}"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('SUBMITTER')")
    @Operation(summary="Gets the status of a dispatch", description="Requires being an authenticated user with the SUBMITTER role", security={@SecurityRequirement(name="api-key")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dispatch information"), @ApiResponse(responseCode="404", description="No dispatch was found for provided ID")})
    public ResponseEntity<DispatchStatusHolder> status(@PathVariable(value="requestId") UUID requestId, Principal principal) {
        DispatchStatusHolder dispatchStatus = this.dispatchService.getDispatchStatus(requestId, principal);
        if (dispatchStatus != null) {
            return ResponseEntity.ok((Object)dispatchStatus);
        }
        return ResponseEntity.notFound().build();
    }

    @RequestMapping(value={"/status-by-hash-list"}, method={RequestMethod.POST})
    @Operation(summary="Gets the message status for a list of message hashes", description="List of message hashes computed as: MD5 hash of destination number updated with content", security={@SecurityRequirement(name="api-key")})
    public ResponseEntity<Map<String, Map<String, Integer>>> statusByHashList(@RequestBody List<String> hashList) {
        LinkedHashMap response = new LinkedHashMap();
        for (Map.Entry entry : this.dispatchService.getMessagesByHexHashList(hashList).entrySet()) {
            HashMap<String, Integer> countForStatus = new HashMap<String, Integer>();
            for (Message message : (List)entry.getValue()) {
                countForStatus.compute(message.getStatus().name(), (messageStatus, exitingCount) -> (exitingCount != null ? exitingCount : 0) + 1);
            }
            response.put(((MD5Hash)entry.getKey()).toHexString(), countForStatus);
        }
        return ResponseEntity.ok(response);
    }

    @RequestMapping(value={"/messages/{fromTimestamp}/{toTimestamp}/totals"}, method={RequestMethod.GET})
    @Operation(summary="Gets the number of messages created between two timestamps", description="[fromTimestamp, toTimestamp)", security={@SecurityRequirement(name="api-key")})
    public ResponseEntity<Long> messageCountsBetweenCreationTimestamps(@PathVariable(value="fromTimestamp") Long fromTimestamp, @PathVariable(value="toTimestamp") Long toTimestamp, Principal principal) {
        return ResponseEntity.ok((Object)this.dispatchService.getMessageCountsBetweenCreationTimestamps(fromTimestamp, toTimestamp, principal.getName()));
    }

    @RequestMapping(value={"/messages/{fromTimestamp}/{toTimestamp}/sort/{sortBy}/{descending}/{startRow}/{fetchCount}"}, method={RequestMethod.GET})
    @Operation(summary="Gets the messages created between two timestamps", description="[fromTimestamp, toTimestamp)", security={@SecurityRequirement(name="api-key")})
    public ResponseEntity<List<Message>> messagesBetweenCreationTimestamps(@PathVariable(value="fromTimestamp") Long fromTimestamp, @PathVariable(value="toTimestamp") Long toTimestamp, @PathVariable(value="sortBy") String sortBy, @PathVariable(value="descending") Boolean descending, @PathVariable(value="startRow") Integer startRow, @PathVariable(value="fetchCount") Integer fetchCount, Principal principal) {
        return ResponseEntity.ok((Object)this.dispatchService.getMessagesBetweenCreationTimestamps(fromTimestamp, toTimestamp, principal.getName(), sortBy, descending, startRow, fetchCount));
    }

    @RequestMapping(value={"/messages/{fromTimestamp}/{toTimestamp}/sort/{sortBy}/{descending}/{startRow}/{fetchCount}/csv"}, method={RequestMethod.GET})
    @Hidden
    public void messagesBetweenCreationTimestampsCSV(@PathVariable(value="fromTimestamp") Long fromTimestamp, @PathVariable(value="toTimestamp") Long toTimestamp, @PathVariable(value="sortBy") String sortBy, @PathVariable(value="descending") Boolean descending, @PathVariable(value="startRow") Integer startRow, @PathVariable(value="fetchCount") Integer fetchCount, Principal principal, HttpServletResponse response) throws IOException {
        Calendar from = Calendar.getInstance(TimeZone.getTimeZone("Europe/Bucharest"));
        Calendar to = Calendar.getInstance(TimeZone.getTimeZone("Europe/Bucharest"));
        from.setTimeInMillis(fromTimestamp);
        to.setTimeInMillis(toTimestamp);
        response.setHeader("Content-disposition", String.format("attachment; filename=mesaje_%04d-%02d-%02d-%04d-%02d-%02d_%s_%s.csv", from.get(1), from.get(2) + 1, from.get(5), to.get(1), to.get(2) + 1, to.get(5), sortBy, descending != false ? "desc" : "asc", Locale.forLanguageTag("RO")));
        List messages = this.dispatchService.getMessagesBetweenCreationTimestamps(fromTimestamp, toTimestamp, principal.getName(), sortBy, descending, startRow, fetchCount);
        CSVFormat format = CSVFormat.EXCEL;
        CSVPrinter csvPrinter = new CSVPrinter((Appendable)response.getWriter(), format);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.forLanguageTag("RO"));
        dateFormat.setTimeZone(TimeZone.getTimeZone("Europe/Bucharest"));
        Function<Date, String> dateFormatter = date -> date == null ? "" : dateFormat.format((Date)date);
        Function<Message, String> sendingStatusFormatter = message -> message.getSendingStatus() == null ? "" : (message.getSendingStatus() == -1 ? "Nesolicitat" : (message.getSendingStatus() == 0 ? (message.getSentDate() == null ? "" : "E\u0219uat") : (message.getSendingStatus() == 1 ? "OK" : "Problema: " + message.getSendingStatus())));
        Function<Message, String> deliveryStatusFormatter = message -> message.getDeliveryStatus() == null ? "" : (message.getDeliveryStatus() == -1 ? "Nesolicitat" : (message.getDeliveryStatus() == 0 ? (message.getDeliveredDate() == null ? "" : "E\u0219uat") : (message.getDeliveryStatus() == 1 ? "OK" : "Problema: " + message.getDeliveryStatus())));
        csvPrinter.printRecord(Arrays.asList("Id", "Expeditor", "Destinatar", "Mesaj", "Data creere", "Data alocare", "Data expediere", "Data livrare", "Expediere", "Livrare"));
        int idx = 0;
        for (Message message2 : messages) {
            csvPrinter.printRecord(Arrays.asList(String.valueOf(message2.getId()), message2.getFromICCID(), message2.getTo(), message2.getContent(), dateFormatter.apply(message2.getCreationDate()), dateFormatter.apply(message2.getAllocationDate()), dateFormatter.apply(message2.getSentDate()), dateFormatter.apply(message2.getDeliveredDate()), sendingStatusFormatter.apply(message2), deliveryStatusFormatter.apply(message2)));
            if (idx++ % 1000 != 0 || idx <= 0) continue;
            csvPrinter.flush();
        }
        csvPrinter.close(true);
    }

    @EventListener
    public void onDisconnect(SessionDisconnectEvent event) {
        Map disconnectedWorkers = (Map)this.workersBySessionId.remove(event.getSessionId());
        if (disconnectedWorkers != null && !disconnectedWorkers.isEmpty()) {
            this.workService.unregisterWorkers(disconnectedWorkers.keySet());
        }
    }

    @MessageMapping(value={"/sms/workers/{id}/register"})
    public void registerWorker(@DestinationVariable(value="id") String id, @Header(value="simpSessionId") String sessionId, Principal principal) {
        Device device = this.deviceService.getDeviceBySimSerialNumber(id);
        if (device != null && principal.getName().equals(device.getOwner())) {
            1 worker = new /* Unavailable Anonymous Inner Class!! */;
            this.workersBySessionId.computeIfAbsent(sessionId, workers -> new ConcurrentHashMap()).put(id, worker);
            this.workService.registerWorker((MessageSender)worker);
        }
    }

    @MessageMapping(value={"/sms/workers/{id}/unregister"})
    public void unregisterWorker(@DestinationVariable(value="id") String id, @Header(value="simpSessionId") String sessionId) {
        this.workersBySessionId.computeIfAbsent(sessionId, workers -> new ConcurrentHashMap()).remove(id);
        this.workService.unregisterWorker(id);
    }

    @MessageMapping(value={"/sms/workers/{id}/confirm-allocation"})
    public void confirmAllocation(@DestinationVariable(value="id") String id, UUID allocationUuid, Principal principal) {
        MessageSender worker = this.workService.getWorker(id, principal.getName());
        if (worker != null) {
            worker.allocationConfirmed(allocationUuid);
        }
    }

    @MessageMapping(value={"/sms/workers/{id}/message-sent/{messageId}"})
    public void messageSent(@DestinationVariable(value="id") String id, MessageSendingInfo messageSendingInfo, Principal principal) {
        MessageSender worker = this.workService.getWorker(id, principal.getName());
        if (worker != null) {
            worker.messageSent(messageSendingInfo.getAllocation(), messageSendingInfo.getDispatchId(), messageSendingInfo.getMessageId(), messageSendingInfo.getSendingStatusId(), messageSendingInfo.getSentDate());
        }
    }

    @MessageMapping(value={"/sms/workers/{id}/message-delivered/{messageId}"})
    public void messageDelivered(@DestinationVariable(value="id") String id, MessageDeliveryInfo messageDeliveryInfo, Principal principal) {
        System.out.println(String.format("Message %d delivered on %s with status id %d", messageDeliveryInfo.getMessageId(), messageDeliveryInfo.getDeliveryDate(), messageDeliveryInfo.getDeliveryStatusId()));
        MessageSender worker = this.workService.getWorker(id, principal.getName());
        if (worker != null) {
            worker.messageDelivered(messageDeliveryInfo.getAllocation(), messageDeliveryInfo.getDispatchId(), messageDeliveryInfo.getMessageId(), messageDeliveryInfo.getDeliveryDate(), messageDeliveryInfo.getDeliveryStatusId());
        }
    }

    @MessageMapping(value={"/sms/dispatches/{id}/pause"})
    @PreAuthorize(value="hasRole('SUBMITTER')")
    @Operation(summary="Pause a dispatch", description="Requires being an authenticated user with the SUBMITTER role", security={@SecurityRequirement(name="api-key")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dispatch information"), @ApiResponse(responseCode="404", description="No dispatch was found for provided ID")})
    public ResponseEntity<DispatchStatusHolder> pauseDispatch(@DestinationVariable(value="id") UUID id, Principal principal) {
        Dispatch liveDispatch = this.workService.getLiveDispatch(id, principal.getName());
        if (liveDispatch != null) {
            this.workService.pauseDispatch(liveDispatch);
            return ResponseEntity.ok((Object)liveDispatch.getDispatchStatusHolder());
        }
        return ResponseEntity.notFound().build();
    }

    @MessageMapping(value={"/sms/dispatches/{id}/resume"})
    @PreAuthorize(value="hasRole('SUBMITTER')")
    @Operation(summary="Resume a dispatch", description="Requires being an authenticated user with the SUBMITTER role", security={@SecurityRequirement(name="api-key")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dispatch information"), @ApiResponse(responseCode="404", description="No dispatch was found for provided ID")})
    public ResponseEntity<DispatchStatusHolder> resumeDispatch(@DestinationVariable(value="id") UUID id, Principal principal) {
        Dispatch liveDispatch = this.workService.getLiveDispatch(id, principal.getName());
        if (liveDispatch != null) {
            this.workService.resumeDispatch(liveDispatch);
            return ResponseEntity.ok((Object)liveDispatch.getDispatchStatusHolder());
        }
        return ResponseEntity.notFound().build();
    }

    @MessageMapping(value={"/sms/dispatches/{id}/cancel"})
    @PreAuthorize(value="hasRole('SUBMITTER')")
    @Operation(summary="Cancel a dispatch", description="Requires being an authenticated user with the SUBMITTER role", security={@SecurityRequirement(name="api-key")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dispatch information"), @ApiResponse(responseCode="404", description="No dispatch was found for provided ID")})
    public ResponseEntity<DispatchStatusHolder> cancelDispatch(@DestinationVariable(value="id") UUID id, Principal principal) {
        Dispatch liveDispatch = this.workService.getLiveDispatch(id, principal.getName());
        if (liveDispatch != null) {
            this.workService.cancel(liveDispatch);
            return ResponseEntity.ok((Object)liveDispatch.getDispatchStatusHolder());
        }
        return ResponseEntity.notFound().build();
    }

    static /* synthetic */ SimpMessagingTemplate access$000(SMSController x0) {
        return x0.simpMessagingTemplate;
    }
}

