/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.controllers.api.v1;

import com.ease.gsms.server.model.Device;
import com.ease.gsms.server.model.DeviceInfo;
import com.ease.gsms.server.model.Sim;
import com.ease.gsms.server.services.DeviceService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.security.Principal;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.socket.messaging.SessionDisconnectEvent;

@RestController
@RequestMapping(value={"/api/v1/device"}, produces={"application/json"})
@Validated
public class DeviceController {
    @Autowired
    DeviceService deviceService;
    @Autowired
    Logger logger;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    private Map<String, String> onlineSenderCache;

    @PostConstruct
    private void init() {
        this.onlineSenderCache = new ConcurrentHashMap();
        this.deviceService.addObserver((device, sims) -> this.simpMessagingTemplate.convertAndSendToUser(device.getOwner(), "/topic/device/device-info", (Object)new DeviceInfo(device, sims)));
    }

    @EventListener
    public void onDisconnect(SessionDisconnectEvent event) {
        String deviceUuid = (String)this.onlineSenderCache.get(event.getSessionId());
        if (deviceUuid != null) {
            this.deviceService.offline(deviceUuid);
        }
    }

    @RequestMapping(value={"/user-devices"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('SENDER') || hasRole('SUBMITTER')")
    @Operation(summary="Returns all devices accessible for sending by the current user", description="Requires being an authenticated user with the SUBMITTER or SENDER role", security={@SecurityRequirement(name="api-key")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Devices could be successfully listed")})
    public ResponseEntity<DeviceInfo[]> getUserDevices(Principal principal) {
        return ResponseEntity.ok((Object)this.deviceService.getUserDevices(principal.getName()));
    }

    @RequestMapping(value={"/{uuid}"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasRole('SENDER') || hasRole('SUBMITTER')")
    @Operation(summary="Returns the device with the given UUID", description="Requires being an authenticated user with the SUBMITTER or SENDER role", security={@SecurityRequirement(name="api-key")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Device was found and data can be provided"), @ApiResponse(responseCode="403", description="Requesting user has no access to device"), @ApiResponse(responseCode="404", description="Device not found")})
    public ResponseEntity<DeviceInfo> getDeviceByUuid(@PathVariable(value="uuid") String uuid, Principal principal) {
        DeviceInfo deviceInfo = this.deviceService.getDeviceInfoByUuid(uuid);
        if (deviceInfo == null) {
            return ResponseEntity.notFound().build();
        }
        if (principal.getName().equals(deviceInfo.getDevice().getOwner())) {
            return ResponseEntity.ok((Object)deviceInfo);
        }
        return ResponseEntity.status((int)403).build();
    }

    @Hidden
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('SENDER')")
    public ResponseEntity<Long> update(@RequestBody DeviceInfo deviceInfo, Principal principal) {
        Device device = deviceInfo.getDevice();
        Sim[] sims = deviceInfo.getSims();
        device.setOwner(principal.getName());
        device.setLastSeen(new Date());
        for (Sim sim : sims) {
            sim.setLastSeen(new Date());
        }
        this.deviceService.update(device, sims);
        return ResponseEntity.ok((Object)device.getId());
    }

    @MessageMapping(value={"/device/sender-online"})
    @SendToUser(value={"/topic/sender-registered"})
    public Long senderOnline(DeviceInfo deviceInfo, Principal principal, @Header(value="simpSessionId") String sessionId) {
        Long id = (Long)this.update(deviceInfo, principal).getBody();
        this.onlineSenderCache.put(sessionId, deviceInfo.getDevice().getUuid());
        return id;
    }

    @MessageMapping(value={"/device/sender-offline"})
    public void senderOffline(String deviceUuid, Principal principal) {
        this.deviceService.offline(deviceUuid);
    }
}

