/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server.controllers;

import com.ease.gsms.server.model.Dispatch;
import com.ease.gsms.server.model.DispatchStatus;
import com.ease.gsms.server.model.Message;
import com.ease.gsms.server.repositories.DispatchRepository;
import com.ease.gsms.server.services.DispatchService;
import java.security.Principal;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MainController {
    @Autowired
    DispatchService dispatchService;
    @Autowired
    private DispatchRepository dispatchRepository;
    @Autowired
    private JdbcTemplate template;

    @RequestMapping(value={"/"})
    public String index(@RequestHeader(value="X-Requested-With", required=false) String requestedWith) {
        if ("com.ease.gsms".equals(requestedWith)) {
            return "redirect:/native-android-sender";
        }
        return "index";
    }

    @RequestMapping(value={"/download-android"})
    public String downloadAndroid() {
        return "download-android";
    }

    @RequestMapping(value={"/sms-creation/multi-sms"})
    public String smsCreationMultiSms() {
        return "sms-creation/multi-sms";
    }

    @RequestMapping(value={"/sms-creation/multi-excel"})
    public String smsCreationMultiExcel() {
        return "sms-creation/multi-excel";
    }

    @RequestMapping(value={"/dispatch/active"})
    public String activeDispatches() {
        return "dispatches/active-dispatches";
    }

    @RequestMapping(value={"/dispatch/device-list"})
    public String deviceList() {
        return "devices/device-list";
    }

    @RequestMapping(value={"/messages/list"})
    public String messageList() {
        return "/messages/message-list";
    }

    @RequestMapping(value={"/native-android-sender"})
    public String nativeAndroidSender(HttpServletRequest request) {
        return "native/android/sender";
    }

    @RequestMapping(value={"/load-runner"})
    @ResponseBody
    public String loadRunner(Principal principal) throws InterruptedException {
        int parallelWorkers = 4;
        LinkedBlockingQueue<Dispatch> dispatchQueue = new LinkedBlockingQueue<Dispatch>(parallelWorkers);
        AtomicInteger mc = new AtomicInteger();
        int i = 0;
        while (i < parallelWorkers) {
            int j = i++;
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        int messageCount = 10000;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1996, 8, 8, 12, 0, 0);
        int messageIndex = 1;
        while (calendar.getTime().getTime() < System.currentTimeMillis()) {
            Message[] messages = new Message[messageCount];
            for (int i2 = 0; i2 < messageCount; ++i2) {
                messages[i2] = new Message(String.format("0720%06d", i2), "Message " + messageIndex++);
                messages[i2].setSendingStatus(Integer.valueOf(1));
                messages[i2].setSentDate(new Date(calendar.getTime().getTime() + (long)(i2 * 1000)));
                messages[i2].setDeliveryStatus(Integer.valueOf(1));
                messages[i2].setDeliveredDate(new Date(calendar.getTime().getTime() + (long)((i2 + 1) * 1000)));
            }
            Dispatch dispatch = new Dispatch(null, UUID.randomUUID(), null, principal.getName(), calendar.getTime(), calendar.getTime(), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(0), DispatchStatus.COMPLETED, messages);
            dispatchQueue.put(dispatch);
            calendar.add(5, 3);
        }
        return "OK";
    }

    static /* synthetic */ DispatchRepository access$000(MainController x0) {
        return x0.dispatchRepository;
    }
}

