/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfiguration
implements WebSocketMessageBrokerConfigurer {
    @Autowired
    private TaskScheduler taskScheduler;

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{"/wsms"}).setAllowedOrigins(new String[]{"*"}).withSockJS();
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        registry.setPreservePublishOrder(true).setApplicationDestinationPrefixes(new String[]{"/app"}).enableSimpleBroker(new String[]{"/queue", "/topic"}).setHeartbeatValue(new long[]{10000L, 20000L}).setTaskScheduler(this.taskScheduler);
        registry.setUserDestinationPrefix("/user");
    }
}

