/*
 * Decompiled with CFR 0.152.
 */
package com.ease.gsms.server;

import freemarker.template.TemplateModelException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.Scope;
import org.springframework.http.CacheControl;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
@EnableWebMvc
@EnableCaching
@EnableScheduling
@EnableAsync
@PropertySource(value={"classpath:sql.properties"})
public class AppConfiguration
implements WebMvcConfigurer {
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        CacheControl cacheControl = CacheControl.noCache();
        registry.addResourceHandler(new String[]{"/apk/**"}).addResourceLocations(new String[]{"classpath:/static/apk/"}).setCacheControl(cacheControl);
        registry.addResourceHandler(new String[]{"/js/**"}).addResourceLocations(new String[]{"classpath:/static/js/"}).setCacheControl(cacheControl);
        registry.addResourceHandler(new String[]{"/css/**"}).addResourceLocations(new String[]{"classpath:/static/css/"}).setCacheControl(cacheControl);
        registry.addResourceHandler(new String[]{"/img/**"}).addResourceLocations(new String[]{"classpath:/static/img/"}).setCacheControl(cacheControl);
        registry.addResourceHandler(new String[]{"/native/**"}).addResourceLocations(new String[]{"classpath:/static/native/"}).setCacheControl(cacheControl);
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/"}).setCacheControl(cacheControl);
    }

    @Bean
    public FreeMarkerConfigurer freeMarkerConfigurer() throws TemplateModelException {
        FreeMarkerConfigurer freeMarkerConfigurer = new FreeMarkerConfigurer();
        freeMarkerConfigurer.setTemplateLoaderPath("classpath:/templates");
        freeMarkerConfigurer.setDefaultEncoding("UTF-8");
        freeMarkerConfigurer.setFreemarkerVariables(Collections.singletonMap("MAX_MESSAGE_SIZE", 612));
        return freeMarkerConfigurer;
    }

    @Bean
    @Scope(value="prototype")
    public Logger produceLogger(InjectionPoint injectionPoint) {
        Class<?> classOnWired = injectionPoint.getMember().getDeclaringClass();
        return LoggerFactory.getLogger(classOnWired);
    }
}

